﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace DocumentProcessing
{
    class Program
    {
        static void Main(string[] args)
        {
            Document doc1 = new Document
            {
                Author = "Jan Kowalski",
                DocumentDate = new DateTime(2000, 01, 01),
                Text = "Czy przybyłem za wcześnie?"
            };
            Document doc2 = new Document
            {
                Author = "Wiesław Zatorski",
                DocumentDate = new DateTime(2001, 01, 01),
                Text = "Wierzcie mi! Nadchodzi nowe milenium."
            };
            DocumentProcessor processor = Configure();
            Console.WriteLine("Przetwarzanie dokumentu nr 1.");
            processor.Process(doc1);
            Console.WriteLine();
            Console.WriteLine("Przetwarzanie dokumentu nr 2.");
            processor.Process(doc2);
            Console.ReadKey();
        }

        // Listing 5-11. Dodawanie etapu przetwarzania wykorzystującego metodę niestatyczną
        static DocumentProcessor Configure()
        {
            DocumentProcessor rc = new DocumentProcessor();
            rc.Processes.Add(DocumentProcesses.TranslateIntoFrench);
            rc.Processes.Add(DocumentProcesses.Spellcheck);
            rc.Processes.Add(DocumentProcesses.Repaginate);

            TrademarkFilter trademarkFilter = new TrademarkFilter();
            trademarkFilter.Trademarks.Add("Helion");
            trademarkFilter.Trademarks.Add("milenium");

            rc.Processes.Add(trademarkFilter.HighlightTrademarks);

            return rc;
        }
    }
}
